/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.chunk_loading;

import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_1944;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2806;
import net.minecraft.class_2818;
import net.minecraft.class_310;
import net.minecraft.class_4076;
import net.minecraft.class_5321;
import net.minecraft.class_631;
import net.minecraft.class_638;
import net.minecraft.class_6603;
import org.apache.commons.lang3.Validate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import qouteall.imm_ptl.core.CHelper;
import qouteall.imm_ptl.core.ClientWorldLoader;
import qouteall.imm_ptl.core.McHelper;
import qouteall.imm_ptl.core.compat.sodium_compatibility.SodiumInterface;
import qouteall.imm_ptl.core.ducks.IEMinecraftClient;
import qouteall.imm_ptl.core.miscellaneous.IPVanillaCopy;
import qouteall.imm_ptl.core.platform_specific.O_O;
import qouteall.q_misc_util.my_util.SignalArged;

@Environment(value=EnvType.CLIENT)
@IPVanillaCopy
public class ImmPtlClientChunkMap
extends class_631 {
    private static final Logger LOGGER = LogManager.getLogger();
    protected final Long2ObjectOpenHashMap<class_2818> chunkMapForMainThread = new Long2ObjectOpenHashMap();
    protected final Long2ObjectOpenHashMap<class_2818> chunkMapForOtherThreads = new Long2ObjectOpenHashMap();
    public final Thread mainThread = ((IEMinecraftClient)class_310.method_1551()).ip_getRunningThread();
    public static final SignalArged<class_2818> clientChunkLoadSignal = new SignalArged();
    public static final SignalArged<class_2818> clientChunkUnloadSignal = new SignalArged();

    public ImmPtlClientChunkMap(class_638 clientWorld, int loadDistance) {
        super(clientWorld, 1);
    }

    public void method_2859(class_1923 chunkPos) {
        Validate.isTrue((Thread.currentThread() == this.mainThread ? 1 : 0) != 0);
        class_2818 chunk = (class_2818)this.chunkMapForMainThread.get(chunkPos.method_8324());
        if (chunk != null) {
            this.modifyChunkMap(chunkMap -> chunkMap.remove(chunkPos.method_8324()));
            O_O.postClientChunkUnloadEvent(chunk);
            this.field_16525.method_18110(chunk);
            SodiumInterface.invoker.onClientChunkUnloaded(this.field_16525, chunkPos.field_9181, chunkPos.field_9180);
            clientChunkUnloadSignal.emit(chunk);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T readChunkMap(Function<Long2ObjectOpenHashMap<class_2818>, T> func) {
        if (Thread.currentThread() == this.mainThread) {
            return func.apply(this.chunkMapForMainThread);
        }
        Long2ObjectOpenHashMap<class_2818> long2ObjectOpenHashMap = this.chunkMapForOtherThreads;
        synchronized (long2ObjectOpenHashMap) {
            return func.apply(this.chunkMapForOtherThreads);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void modifyChunkMap(Consumer<Long2ObjectOpenHashMap<class_2818>> func) {
        Validate.isTrue((Thread.currentThread() == this.mainThread ? 1 : 0) != 0);
        func.accept(this.chunkMapForMainThread);
        Long2ObjectOpenHashMap<class_2818> long2ObjectOpenHashMap = this.chunkMapForOtherThreads;
        synchronized (long2ObjectOpenHashMap) {
            func.accept(this.chunkMapForOtherThreads);
        }
    }

    public class_2818 method_2857(int x, int z, class_2806 chunkStatus, boolean create) {
        return this.readChunkMap(chunkMap -> {
            class_2818 chunk = (class_2818)chunkMap.get(class_1923.method_8331((int)x, (int)z));
            if (chunk != null) {
                return chunk;
            }
            return create ? this.field_3676 : null;
        });
    }

    public boolean isChunkLoaded(int x, int z) {
        return this.readChunkMap(chunkMap -> chunkMap.containsKey(class_1923.method_8331((int)x, (int)z)));
    }

    public void method_49630(int x, int z, class_2540 friendlyByteBuf) {
        Validate.isTrue((Thread.currentThread() == this.mainThread ? 1 : 0) != 0);
        long chunkPosLong = class_1923.method_8331((int)x, (int)z);
        class_2818 worldChunk = (class_2818)this.chunkMapForMainThread.get(chunkPosLong);
        class_1923 chunkPos = new class_1923(x, z);
        if (worldChunk == null) {
            LOGGER.error("Trying to replace biomes for missing chunk {} {}", (Object)x, (Object)z);
        } else {
            worldChunk.method_49525(friendlyByteBuf);
        }
    }

    public class_2818 method_16020(int x, int z, class_2540 buf, class_2487 nbt, Consumer<class_6603.class_6605> consumer) {
        Validate.isTrue((Thread.currentThread() == this.mainThread ? 1 : 0) != 0);
        long chunkPosLong = class_1923.method_8331((int)x, (int)z);
        class_2818 worldChunk = (class_2818)this.chunkMapForMainThread.get(chunkPosLong);
        if (worldChunk == null) {
            worldChunk = new class_2818((class_1937)this.field_16525, new class_1923(x, z));
            this.loadChunkDataFromPacket(buf, nbt, worldChunk, consumer);
            class_2818 worldChunkToPut = worldChunk;
            this.modifyChunkMap(chunkMap -> chunkMap.put(chunkPosLong, (Object)worldChunkToPut));
        } else {
            this.loadChunkDataFromPacket(buf, nbt, worldChunk, consumer);
        }
        this.field_16525.method_23782(new class_1923(x, z));
        O_O.postClientChunkLoadEvent(worldChunk);
        SodiumInterface.invoker.onClientChunkLoaded(this.field_16525, x, z);
        clientChunkLoadSignal.emit(worldChunk);
        return worldChunk;
    }

    private void loadChunkDataFromPacket(class_2540 buf, class_2487 nbt, class_2818 worldChunk, Consumer<class_6603.class_6605> consumer) {
        try {
            worldChunk.method_12224(buf, nbt, consumer);
        }
        catch (Exception e) {
            LOGGER.error("Error deserializing chunk packet {} {}", (Object)worldChunk.method_12200().method_27983().method_29177(), (Object)worldChunk.method_12004(), (Object)e);
            CHelper.printChat((class_2561)class_2561.method_43470((String)"Failed to deserialize chunk packet. %s %s %s".formatted(worldChunk.method_12200().method_27983().method_29177(), worldChunk.method_12004().field_9181, worldChunk.method_12004().field_9180)).method_10852((class_2561)class_2561.method_43470((String)" Report issue:")).method_10852((class_2561)McHelper.getLinkText(O_O.getIssueLink())).method_27692(class_124.field_1061));
            throw new RuntimeException(e);
        }
    }

    public List<class_2818> getCopiedChunkList() {
        return this.readChunkMap(chunkMap -> Arrays.asList((class_2818[])chunkMap.values().toArray((Object[])new class_2818[0])));
    }

    public void method_20317(int x, int z) {
    }

    public void method_20180(int r) {
    }

    public String method_12122() {
        return "Client Chunks (ImmPtl) " + this.method_14151();
    }

    public int method_14151() {
        return this.readChunkMap(chunkMap -> chunkMap.size());
    }

    public void method_12247(class_1944 lightType, class_4076 chunkSectionPos) {
        ClientWorldLoader.getWorldRenderer((class_5321<class_1937>)this.field_16525.method_27983()).method_8571(chunkSectionPos.method_18674(), chunkSectionPos.method_18683(), chunkSectionPos.method_18687());
    }
}

